//               ------ PAMELA Digitizer ------
// 
// Date, release and how-to: see file  Pamelagp2Digits.cxx 
// 
// NB: Check length  physics  packet [packet type (0x10 = physics data)]
//
#include <sstream>
#include <fstream>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "Riostream.h"
#include "TFile.h"
#include "TDirectory.h"
#include "TTree.h"
#include "TLeafI.h"
#include "TH1.h"
#include "TH2.h"
#include "TF1.h"
#include "TMath.h"
#include "TRandom.h"
#include "TSQLServer.h"
#include "TSystem.h"
#include "CalibTrk1Event.h"
#include "CalibTrk2Event.h"
//
#include "Digitizer.h"
#include "CRC.h"
//
#include <PamelaRun.h>
#include <physics/calorimeter/CalorimeterEvent.h>
#include <CalibCalPedEvent.h>
#include "GLTables.h"
//
extern "C"{
  short crc(short, short);
};
//

Digitizer::Digitizer(TTree* tree, char* &file_raw,int nspe,int ntof,int ncat,int ncas,int ncar,int ncal,int nnd,int nstr){
  fhBookTree = tree;
  fFilename =  file_raw;
  fCounter = 0;
  fCounterPhys = 0; // SO 5/12/'07
  fOBT = 0;

  //
  // DB  connections
  //
  TString host = "mysql://localhost/pamelaprod";
  TString user = "anonymous";
  TString psw = "";
  //
  const char *pamdbhost=gSystem->Getenv("PAM_DBHOST");
  const char *pamdbuser=gSystem->Getenv("PAM_DBUSER");
  const char *pamdbpsw=gSystem->Getenv("PAM_DBPSW");
  if ( !pamdbhost ) pamdbhost = "";
  if ( !pamdbuser ) pamdbuser = "";
  if ( !pamdbpsw ) pamdbpsw = "";
  if ( strcmp(pamdbhost,"") ) host = pamdbhost;
  if ( strcmp(pamdbuser,"") ) user = pamdbuser;
  if ( strcmp(pamdbpsw,"") ) psw = pamdbpsw;
  fDbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());
  //
  GL_TABLES *glt = new GL_TABLES(host,user,psw);
  if ( glt->IsConnected(fDbc) ) printf("\n DB INFORMATION:\n SQL: %s Version: %s Host %s Port %i \n\n",fDbc->GetDBMS(),fDbc->ServerInfo(),fDbc->GetHost(),fDbc->GetPort());
  //
  // Use UTC in the DB and make timeout bigger
  //
  stringstream myquery;
  myquery.str("");
  myquery << "SET time_zone='+0:00'";
  fDbc->Query(myquery.str().c_str());
  myquery.str("");
  myquery << "SET wait_timeout=173000;";
  fDbc->Query(myquery.str().c_str());
  //
  
  std:: cout << "preparing tree" << endl;

  ntf=(int*)malloc(1 *sizeof(int));
  *ntf=ntof;
  Ipltof=(UChar_t*)malloc(ntof *sizeof(UChar_t));
  Ipaddle=(UChar_t*)malloc(ntof *sizeof(UChar_t));
  // Ipartof=(UShort_t*)malloc(ntof *sizeof(UShort_t));
  Ipartof=(UChar_t*)malloc(ntof *sizeof(UChar_t));
  Xintof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Yintof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Zintof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Xouttof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Youttof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Zouttof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Ereltof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Timetof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Pathtof=(Float_t*)malloc(ntof *sizeof(Float_t));
  P0tof=(Float_t*)malloc(ntof *sizeof(Float_t));
  Iparcat=(UChar_t*)malloc(ncat *sizeof(UChar_t));
  Icat=(UChar_t*)malloc(ncat *sizeof(UChar_t));
  Xincat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Yincat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Zincat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Xoutcat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Youtcat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Zoutcat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Erelcat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Timecat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Pathcat=(Float_t*)malloc(ncat *sizeof(Float_t));
  P0cat=(Float_t*)malloc(ncat *sizeof(Float_t));
  Iparcas=(UChar_t*)malloc(ncas *sizeof(UChar_t));
  Icas=(UChar_t*)malloc(ncas *sizeof(UChar_t));
  Xincas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Yincas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Zincas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Xoutcas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Youtcas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Zoutcas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Erelcas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Timecas=(Float_t*)malloc(ncas *sizeof(Float_t));
  Pathcas=(Float_t*)malloc(ncas *sizeof(Float_t));
  P0cas=(Float_t*)malloc(ncas *sizeof(Float_t));
  //  Iparspe=(UShort_t*)malloc(nspe *sizeof(UShort_t));
  Iparspe=(UChar_t*)malloc(nspe *sizeof(UChar_t));
  Itrpb=(UChar_t*)malloc(nspe *sizeof(UChar_t));
  Itrsl=(UChar_t*)malloc(nspe *sizeof(UChar_t));
  Itspa=(UChar_t*)malloc(nspe *sizeof(UChar_t));
  Xinspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Yinspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Zinspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Xoutspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Youtspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Zoutspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Xavspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Yavspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Zavspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Erelspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  Pathspe=(Float_t*)malloc(nspe *sizeof(Float_t));
  P0spe=(Float_t*)malloc(nspe *sizeof(Float_t));;
  Nxmult=(UChar_t*)malloc(nspe *sizeof(UChar_t));
  Nymult=(UChar_t*)malloc(nspe *sizeof(UChar_t));
  Istripx=(UShort_t*)malloc(nstr *sizeof(UShort_t));
  Qstripx=(Float_t*)malloc(nstr *sizeof(Float_t));
  Xstripx=(Float_t*)malloc(nstr *sizeof(Float_t));
  Npstripx=(UChar_t*)malloc(nstr *sizeof(UChar_t));
  Ntstripx=(UChar_t*)malloc(nstr *sizeof(UChar_t));
  Npstripy=(UChar_t*)malloc(nstr *sizeof(UChar_t));
  Ntstripy=(UChar_t*)malloc(nstr *sizeof(UChar_t));
  Istripy=(UShort_t*)malloc(nstr *sizeof(UShort_t));
  Qstripy=(Float_t*)malloc(nstr *sizeof(Float_t));
  Ystripy=(Float_t*)malloc(nstr *sizeof(Float_t));
  Icapl=(UChar_t*)malloc(ncal *sizeof(UChar_t));
  Icasi=(UChar_t*)malloc(ncal *sizeof(UChar_t));
  Icast=(UChar_t*)malloc(ncal *sizeof(UChar_t));
  Xincal=(Float_t*)malloc(ncal *sizeof(Float_t));
  Yincal=(Float_t*)malloc(ncal *sizeof(Float_t));
  Zincal=(Float_t*)malloc(ncal *sizeof(Float_t));
  Erelcal=(Float_t*)malloc(ncal *sizeof(Float_t));
  Itubend=(UChar_t*)malloc(nnd *sizeof(UChar_t));
  Iparnd=(UChar_t*)malloc(nnd *sizeof(UChar_t));
  Xinnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Yinnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Zinnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Xoutnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Youtnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Zoutnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Erelnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Timend=(Float_t*)malloc(nnd *sizeof(Float_t));
  Pathnd=(Float_t*)malloc(nnd *sizeof(Float_t));
  P0nd=(Float_t*)malloc(nnd *sizeof(Float_t));
  Iparcard=(UChar_t*)malloc(ncar *sizeof(UChar_t));
  Icard=(UChar_t*)malloc(ncar *sizeof(UChar_t));
  Xincard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Yincard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Zincard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Xoutcard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Youtcard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Zoutcard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Erelcard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Timecard=(Float_t*)malloc(ncar *sizeof(Float_t));
  Pathcard=(Float_t*)malloc(ncar *sizeof(Float_t));
  P0card=(Float_t*)malloc(ncar *sizeof(Float_t));



  // prepare tree//modified by E.Vannuccini 03/08
  if(fhBookTree->GetBranch("Irun"))fhBookTree->SetBranchAddress("Irun",&Irun);
  if(fhBookTree->GetBranch("Ievnt"))fhBookTree->SetBranchAddress("Ievnt",&Ievnt);
  if(fhBookTree->GetBranch("Ipa"))fhBookTree->SetBranchAddress("Ipa",&Ipa);
  if(fhBookTree->GetBranch("X0"))fhBookTree->SetBranchAddress("X0",&X0);
  if(fhBookTree->GetBranch("Y0"))fhBookTree->SetBranchAddress("Y0",&Y0);
  if(fhBookTree->GetBranch("Z0"))fhBookTree->SetBranchAddress("Z0",&Z0);
  if(fhBookTree->GetBranch("Theta"))fhBookTree->SetBranchAddress("Theta",&Theta);
  if(fhBookTree->GetBranch("Phi"))fhBookTree->SetBranchAddress("Phi",&Phi);
  if(fhBookTree->GetBranch("P0"))fhBookTree->SetBranchAddress("P0",&P0);
  if(fhBookTree->GetBranch("Nthtof"))fhBookTree->SetBranchAddress("Nthtof",&Nthtof);
  if(fhBookTree->GetBranch("Ipltof"))fhBookTree->SetBranchAddress("Ipltof",Ipltof);///////////////////////////
  if(fhBookTree->GetBranch("Ipaddle"))fhBookTree->SetBranchAddress("Ipaddle",Ipaddle);
  if(fhBookTree->GetBranch("Ipartof"))fhBookTree->SetBranchAddress("Ipartof",Ipartof);
  if(fhBookTree->GetBranch("Xintof"))fhBookTree->SetBranchAddress("Xintof",Xintof);
  if(fhBookTree->GetBranch("Yintof"))fhBookTree->SetBranchAddress("Yintof",Yintof);
  if(fhBookTree->GetBranch("Zintof"))fhBookTree->SetBranchAddress("Zintof",Zintof);
  if(fhBookTree->GetBranch("Xouttof"))fhBookTree->SetBranchAddress("Xouttof",Xouttof);
  if(fhBookTree->GetBranch("Youttof"))fhBookTree->SetBranchAddress("Youttof",Youttof);
  if(fhBookTree->GetBranch("Zouttof"))fhBookTree->SetBranchAddress("Zouttof",Zouttof);
  if(fhBookTree->GetBranch("Ereltof"))fhBookTree->SetBranchAddress("Ereltof",Ereltof);
  if(fhBookTree->GetBranch("Timetof"))fhBookTree->SetBranchAddress("Timetof",Timetof);
  if(fhBookTree->GetBranch("Pathtof"))fhBookTree->SetBranchAddress("Pathtof",Pathtof);
  if(fhBookTree->GetBranch("P0tof"))fhBookTree->SetBranchAddress("P0tof",P0tof);
  if(fhBookTree->GetBranch("Nthcat"))fhBookTree->SetBranchAddress("Nthcat",&Nthcat);
  if(fhBookTree->GetBranch("Iparcat"))fhBookTree->SetBranchAddress("Iparcat",Iparcat);
  if(fhBookTree->GetBranch("Icat"))fhBookTree->SetBranchAddress("Icat",Icat);
  if(fhBookTree->GetBranch("Xincat"))fhBookTree->SetBranchAddress("Xincat",Xincat);
  if(fhBookTree->GetBranch("Yincat"))fhBookTree->SetBranchAddress("Yincat",Yincat);
  if(fhBookTree->GetBranch("Zincat"))fhBookTree->SetBranchAddress("Zincat",Zincat);
  if(fhBookTree->GetBranch("Xoutcat"))fhBookTree->SetBranchAddress("Xoutcat",Xoutcat);
  if(fhBookTree->GetBranch("Youtcat"))fhBookTree->SetBranchAddress("Youtcat",Youtcat);
  if(fhBookTree->GetBranch("Zoutcat"))fhBookTree->SetBranchAddress("Zoutcat",Zoutcat);
  if(fhBookTree->GetBranch("Erelcat"))fhBookTree->SetBranchAddress("Erelcat",Erelcat);
  if(fhBookTree->GetBranch("Timecat"))fhBookTree->SetBranchAddress("Timecat",Timecat);
  if(fhBookTree->GetBranch("Pathcat"))fhBookTree->SetBranchAddress("Pathcat",Pathcat);
  if(fhBookTree->GetBranch("P0cat"))fhBookTree->SetBranchAddress("P0cat",P0cat);
  if(fhBookTree->GetBranch("Nthcas"))fhBookTree->SetBranchAddress("Nthcas",&Nthcas);
  if(fhBookTree->GetBranch("Iparcas"))fhBookTree->SetBranchAddress("Iparcas",Iparcas);
  if(fhBookTree->GetBranch("Icas"))fhBookTree->SetBranchAddress("Icas",Icas);///////////////////////////////
  if(fhBookTree->GetBranch("Xincas"))fhBookTree->SetBranchAddress("Xincas",Xincas);
  if(fhBookTree->GetBranch("Yincas"))fhBookTree->SetBranchAddress("Yincas",Yincas);
  if(fhBookTree->GetBranch("Zincas"))fhBookTree->SetBranchAddress("Zincas",Zincas);
  if(fhBookTree->GetBranch("Xoutcas"))fhBookTree->SetBranchAddress("Xoutcas",Xoutcas);
  if(fhBookTree->GetBranch("Youtcas"))fhBookTree->SetBranchAddress("Youtcas",Youtcas);
  if(fhBookTree->GetBranch("Zoutcas"))fhBookTree->SetBranchAddress("Zoutcas",Zoutcas);
  if(fhBookTree->GetBranch("Erelcas"))fhBookTree->SetBranchAddress("Erelcas",Erelcas);
  if(fhBookTree->GetBranch("Timecas"))fhBookTree->SetBranchAddress("Timecas",Timecas);
  if(fhBookTree->GetBranch("Pathcas"))fhBookTree->SetBranchAddress("Pathcas",Pathcas);
  if(fhBookTree->GetBranch("P0cas"))fhBookTree->SetBranchAddress("P0cas",P0cas);
  if(fhBookTree->GetBranch("Nthspe"))fhBookTree->SetBranchAddress("Nthspe",&Nthspe);
  if(fhBookTree->GetBranch("Iparspe"))fhBookTree->SetBranchAddress("Iparspe",Iparspe);
  if(fhBookTree->GetBranch("Itrpb"))fhBookTree->SetBranchAddress("Itrpb",Itrpb);
  if(fhBookTree->GetBranch("Itrsl"))fhBookTree->SetBranchAddress("Itrsl",Itrsl);
  if(fhBookTree->GetBranch("Itspa"))fhBookTree->SetBranchAddress("Itspa",Itspa);
  if(fhBookTree->GetBranch("Xinspe"))fhBookTree->SetBranchAddress("Xinspe",Xinspe);
  if(fhBookTree->GetBranch("Yinspe"))fhBookTree->SetBranchAddress("Yinspe",Yinspe);
  if(fhBookTree->GetBranch("Zinspe"))fhBookTree->SetBranchAddress("Zinspe",Zinspe);
  if(fhBookTree->GetBranch("Xoutspe"))fhBookTree->SetBranchAddress("Xoutspe",Xoutspe);
  if(fhBookTree->GetBranch("Youtspe"))fhBookTree->SetBranchAddress("Youtspe",Youtspe);
  if(fhBookTree->GetBranch("Zoutspe"))fhBookTree->SetBranchAddress("Zoutspe",Zoutspe);
  if(fhBookTree->GetBranch("Xavspe"))fhBookTree->SetBranchAddress("Xavspe",Xavspe);
  if(fhBookTree->GetBranch("Yavspe"))fhBookTree->SetBranchAddress("Yavspe",Yavspe);
  if(fhBookTree->GetBranch("Zavspe"))fhBookTree->SetBranchAddress("Zavspe",Zavspe);
  if(fhBookTree->GetBranch("Erelspe"))fhBookTree->SetBranchAddress("Erelspe",Erelspe);
  if(fhBookTree->GetBranch("Pathspe"))fhBookTree->SetBranchAddress("Pathspe",Pathspe);
  if(fhBookTree->GetBranch("P0spe"))fhBookTree->SetBranchAddress("P0spe",P0spe);
  if(fhBookTree->GetBranch("Nxmult"))fhBookTree->SetBranchAddress("Nxmult",Nxmult);
  if(fhBookTree->GetBranch("Nymult"))fhBookTree->SetBranchAddress("Nymult",Nymult);
  if(fhBookTree->GetBranch("Nstrpx"))fhBookTree->SetBranchAddress("Nstrpx",&Nstrpx);
  if(fhBookTree->GetBranch("Npstripx"))fhBookTree->SetBranchAddress("Npstripx",Npstripx);
  if(fhBookTree->GetBranch("Ntstripx"))fhBookTree->SetBranchAddress("Ntstripx",Ntstripx);
  if(fhBookTree->GetBranch("Istripx"))fhBookTree->SetBranchAddress("Istripx",Istripx);
  if(fhBookTree->GetBranch("Qstripx"))fhBookTree->SetBranchAddress("Qstripx",Qstripx);
  if(fhBookTree->GetBranch("Xstripx"))fhBookTree->SetBranchAddress("Xstripx",Xstripx);
  if(fhBookTree->GetBranch("Nstrpy"))fhBookTree->SetBranchAddress("Nstrpy",&Nstrpy);
  if(fhBookTree->GetBranch("Npstripy"))fhBookTree->SetBranchAddress("Npstripy",Npstripy);
  if(fhBookTree->GetBranch("Ntstripy"))fhBookTree->SetBranchAddress("Ntstripy",Ntstripy);
  if(fhBookTree->GetBranch("Istripy"))fhBookTree->SetBranchAddress("Istripy",Istripy);
  if(fhBookTree->GetBranch("Qstripy"))fhBookTree->SetBranchAddress("Qstripy",Qstripy);///////////////////////
  if(fhBookTree->GetBranch("Ystripy"))fhBookTree->SetBranchAddress("Ystripy",Ystripy);
  if(fhBookTree->GetBranch("Nthcali"))fhBookTree->SetBranchAddress("Nthcali",&Nthcali);
  if(fhBookTree->GetBranch("Icaplane"))fhBookTree->SetBranchAddress("Icaplane",Icaplane);
  if(fhBookTree->GetBranch("Icastrip"))fhBookTree->SetBranchAddress("Icastrip",Icastrip);
  if(fhBookTree->GetBranch("Icamod"))fhBookTree->SetBranchAddress("Icamod",Icamod);
  if(fhBookTree->GetBranch("Enestrip"))fhBookTree->SetBranchAddress("Enestrip",Enestrip);
  if(fhBookTree->GetBranch("Nthcal"))fhBookTree->SetBranchAddress("Nthcal",&Nthcal);
  if(fhBookTree->GetBranch("Icapl"))fhBookTree->SetBranchAddress("Icapl",Icapl);
  if(fhBookTree->GetBranch("Icasi"))fhBookTree->SetBranchAddress("Icasi",Icasi);
  if(fhBookTree->GetBranch("Icast"))fhBookTree->SetBranchAddress("Icast",Icast);
  if(fhBookTree->GetBranch("Xincal"))fhBookTree->SetBranchAddress("Xincal",Xincal);
  if(fhBookTree->GetBranch("Yincal"))fhBookTree->SetBranchAddress("Yincal",Yincal);
  if(fhBookTree->GetBranch("Zincal"))fhBookTree->SetBranchAddress("Zincal",Zincal);
  if(fhBookTree->GetBranch("Erelcal"))fhBookTree->SetBranchAddress("Erelcal",Erelcal);
  if(fhBookTree->GetBranch("Nthnd"))fhBookTree->SetBranchAddress("Nthnd",&Nthnd);
  if(fhBookTree->GetBranch("Itubend"))fhBookTree->SetBranchAddress("Itubend",Itubend);
  if(fhBookTree->GetBranch("Iparnd"))fhBookTree->SetBranchAddress("Iparnd",Iparnd);
  if(fhBookTree->GetBranch("Xinnd"))fhBookTree->SetBranchAddress("Xinnd",Xinnd);/////////////////////////
  if(fhBookTree->GetBranch("Yinnd"))fhBookTree->SetBranchAddress("Yinnd",Yinnd);
  if(fhBookTree->GetBranch("Zinnd"))fhBookTree->SetBranchAddress("Zinnd",Zinnd);
  if(fhBookTree->GetBranch("Xoutnd"))fhBookTree->SetBranchAddress("Xoutnd",Xoutnd);
  if(fhBookTree->GetBranch("Youtnd"))fhBookTree->SetBranchAddress("Youtnd",Youtnd);
  if(fhBookTree->GetBranch("Zoutnd"))fhBookTree->SetBranchAddress("Zoutnd",Zoutnd);
  if(fhBookTree->GetBranch("Erelnd"))fhBookTree->SetBranchAddress("Erelnd",Erelnd);
  if(fhBookTree->GetBranch("Timend"))fhBookTree->SetBranchAddress("Timend",Timend);
  if(fhBookTree->GetBranch("Pathnd"))fhBookTree->SetBranchAddress("Pathnd",Pathnd);
  if(fhBookTree->GetBranch("P0nd"))fhBookTree->SetBranchAddress("P0nd",P0nd);
  if(fhBookTree->GetBranch("Nthcard"))fhBookTree->SetBranchAddress("Nthcard",&Nthcard);/////////////////////
  if(fhBookTree->GetBranch("Iparcard"))fhBookTree->SetBranchAddress("Iparcard",Iparcard);
  if(fhBookTree->GetBranch("Icard"))fhBookTree->SetBranchAddress("Icard",Icard);
  if(fhBookTree->GetBranch("Xincard"))fhBookTree->SetBranchAddress("Xincard",Xincard);
  if(fhBookTree->GetBranch("Yincard"))fhBookTree->SetBranchAddress("Yincard",Yincard);
  if(fhBookTree->GetBranch("Zincard"))fhBookTree->SetBranchAddress("Zincard",Zincard);
  if(fhBookTree->GetBranch("Xoutcard"))fhBookTree->SetBranchAddress("Xoutcard",Xoutcard);
  if(fhBookTree->GetBranch("Youtcard"))fhBookTree->SetBranchAddress("Youtcard",Youtcard);/////////////////
  if(fhBookTree->GetBranch("Zoutcard"))fhBookTree->SetBranchAddress("Zoutcard",Zoutcard);
  if(fhBookTree->GetBranch("Erelcard"))fhBookTree->SetBranchAddress("Erelcard",Erelcard);
  if(fhBookTree->GetBranch("Timecard"))fhBookTree->SetBranchAddress("Timecard",Timecard);
  if(fhBookTree->GetBranch("Pathcard"))fhBookTree->SetBranchAddress("Pathcard",Pathcard);
  //  if(fhBookTree->GetBranch("P0card"))fhBookTree->SetBranchAddress("P0card",P0card);
//    fhBookTree->SetBranchStatus("*",0); //modified by E.Vannuccini 03/08
}

void Digitizer::Close(){
  delete fhBookTree;
}

void Digitizer::Loop() {
  //
  // opens the raw output file and loops over the events
  //
  fOutputfile.open(fFilename, ios::out | ios::binary);
  //fOutputfile.open(Form("Output%s",fFilename), ios::out | ios::binary);
  //
  // Load in memory and save at the beginning of file the calorimeter calibration
  //
  CaloLoadCalib();
  DigitizeCALOCALIB();

  //  load, digitize and write tracker calibration
  LoadTrackCalib();
  
  DigitizeTrackCalib(1);
  UInt_t length=fTracklength*2;
  DigitizePSCU(length,0x12,fDataPSCU);
  AddPadding();
  WriteTrackCalib(); 
  
  DigitizeTrackCalib(2);
  length=fTracklength*2;
  DigitizePSCU(length,0x13,fDataPSCU);
  AddPadding();
  WriteTrackCalib();

  DigitizeRunHeader();
  WriteRunHeader();

  LoadMipCor();  // some initialization of parameters -not used now-
  //  end loading, digitizing and writing tracker calibration
  // TOF ------ read calibration file (get A1, A2, lambda1, lambda2)
  const int np=48;
  float *atte1,*atte2,*lambda1,*lambda2;
  atte1=(float *)malloc(np *sizeof(float));
  atte2=(float *)malloc(np *sizeof(float));
  lambda1=(float *)malloc(np *sizeof(float));
  lambda2=(float *)malloc(np *sizeof(float));
  LoadTOFCalib(np,atte1,atte2,lambda1,lambda2);
  //end tof calib
  //
  // loops over the events
  //
  
  Int_t nentries = fhBookTree->GetEntriesFast();
  Long64_t nbytes = 0;
    for (Int_t i=0; i<nentries;i++) {
      nbytes += fhBookTree->GetEntry(i);
      // read detectors sequentially:
      // http://www.ts.infn.it/fileadmin/documents/physics/experiments/wizard/cpu/gen_arch/RM_Acquisition.pdf
      // on pamelatov: /cvs/yoda/techmodel/physics/NeutronDetectorReader.cpp
      DigitizeTOF(np,atte1,atte2,lambda1,lambda2);
      DigitizeAC();
      DigitizeCALO();
      DigitizeTrack();
      DigitizeS4();
      DigitizeND();
      //
      // Add padding to 64 bits
      //
      AddPadding();
      //
      // Create CPU header, we need packet type (0x10 = physics data) and packet length.
      //
      UInt_t length=2*(fCALOlength+fACbuffer+fTracklength+fNDbuffer+fS4buffer)+fPadding+fTOFbuffer+fTRIGGERbuffer;
      //UInt_t length=2*(fCALOlength+fACbuffer+fTracklength+fNDbuffer)+fPadding+fTOFbuffer+fTRIGGERbuffer;
      DigitizePSCU(length,0x10,fDataPSCU);
      if ((i%1000)==0) cout << "writing event " << i << endl;
      WriteData();
  }
  DigitizeRunTrailer();
  WriteRunTrailer();
  
  fOutputfile.close();
  cout << "files closed" << endl;
};


void Digitizer::ReadData(){

  UShort_t InData[64];

  // for debuggigng purposes only, write your own routine if you like (many
  // hardwired things.
  
  ifstream InputFile;

  // if (!InputFile) {

  //     std::cout << "ERROR" << endl;
  //     // An error occurred!
  //     // myFile.gcount() returns the number of bytes read.
  //     // calling myFile.clear() will reset the stream state
  //     // so it is usable again.
  //   };


  
  //InputFile.seekg(0);

  InputFile.open(fFilename, ios::in | ios::binary);
  //    fOutputfile.seekg(0);
  if (!InputFile.is_open()) std::cout << "ERROR" << endl;

  InputFile.seekg(0);
  
  for (Int_t k=0; k<=1000; k++){
    InputFile.read(reinterpret_cast<char*>(InData),384*sizeof(UShort_t));

    std::cout << "Read back: " << endl << endl;

    for (Int_t i=0; i<=384; i++){
      printf("%4x ", InData[i]);   
      if ((i+1)%8 ==0) cout << endl;
    }

  }
  cout << endl;
  InputFile.close();

};
